/*
 * Avid DNxHD Codec
 * Copyright (c) 2006 Thomas Parmegiani DoremiLabs.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file DNxHD.c
 * DNxHD Video Codec
 */

#include "avcodec.h"
#include "AvidDNxHDCodec.h"

typedef struct DNxHDVideoContext {
  AvidDNxHDCodec DNxHD;
  unsigned char *ucomBuffer;
} DNxHDVideoContext;

/* RAW Decoder Implementation */

static int DNxHD_init_decoder(AVCodecContext *avctx)
{
    DNxHDVideoContext *context = (DNxHDVideoContext *)avctx->priv_data;
    context->ucomBuffer = NULL;

    init_AvidDNxHDCodec(&context->DNxHD);
    avctx->pix_fmt = PIX_FMT_UYVY422;
    avctx->bits_per_sample = 8;

    //context->length = avpicture_get_size(avctx->pix_fmt, avctx->width, avctx->height);
    //context->pic.pict_type = FF_I_TYPE;
    //context->pic.key_frame = 1;
    //avctx->coded_frame= &context->pic;
    return 0;
}

static int DNxHD_decode(AVCodecContext *avctx,
                            void *data, int *data_size,
                            uint8_t *buf, int buf_size)
{
    DNxHDVideoContext *context = avctx->priv_data;
    compDetails *pCompDetails,pCompDetails_s;
    short width, height;
    AVPicture * picture = (AVPicture *) data;
    long lStatus;
    int i = 0;

    pCompDetails = &pCompDetails_s;

    lStatus = GetCompressedFrameDetails(&context->DNxHD, buf, pCompDetails);
    if (lStatus != DNxHDCODEC_SUCCESSFUL)
    {
      return -1;
    }

    width = pCompDetails->active_line_width;
    height = pCompDetails->active_line_height;

    avctx->width = width;
    avctx->height = height;

    //av_log(NULL, AV_LOG_DEBUG, "Dim width %d height %d bits : %d\n", width, height, pCompDetails->pixel_component_bit_depth_s);
    //avcodec_set_dimensions(avctx, width, height);

    //frame->interlaced_frame = avctx->coded_frame->interlaced_frame;
    //frame->top_field_first = avctx->coded_frame->top_field_first;

    if (context->ucomBuffer == NULL)
      context->ucomBuffer = (unsigned char*) av_malloc(width * height * 4);
    if (context->ucomBuffer == NULL)
    {
      //av_log(NULL, AV_LOG_DEBUG, "av_malloc error \n");
      return -1;
    } 

    lStatus = DecodeFrame(&context->DNxHD, buf, context->ucomBuffer);
    if(lStatus != DNxHDCODEC_SUCCESSFUL)
    { 
      //av_log(NULL, AV_LOG_DEBUG, "Decode frame error %d \n", lStatus);
      return -1;
    }

    while (i <  (((width * height * 4)/2) - 2))
    {
      context->ucomBuffer[i] = context->ucomBuffer[i * 2];
      i++;
    }
    avpicture_fill(picture, context->ucomBuffer, avctx->pix_fmt, avctx->width, avctx->height);

    //av_log(NULL, AV_LOG_DEBUG, "%x %x %x %x\n", context->ucomBuffer[0],context->ucomBuffer[1],context->ucomBuffer[2],context->ucomBuffer[3]); 

    *data_size = sizeof(AVPicture);
    return buf_size;
}

static int DNxHD_close_decoder(AVCodecContext *avctx)
{
  DNxHDVideoContext *context = avctx->priv_data;

  if (context->ucomBuffer != NULL)
  {
    av_free(context->ucomBuffer);
    context->ucomBuffer = NULL;
  }

    return 0;
}

AVCodec DNxHDvideo_decoder = {
    "AvidDNxHD",
    CODEC_TYPE_VIDEO,
    CODEC_ID_DNXHD,
    sizeof(DNxHDVideoContext),
    DNxHD_init_decoder,
    NULL,
    DNxHD_close_decoder,
    DNxHD_decode,
};
