#include "avformat.h"
#include <unistd.h>
#include <sys/types.h>

typedef struct {
	char*	buf;
	int	buflen, bufused;
    FILE *FRead;
} BUF;

static int mem_close(URLContext* h)
{
	BUF*	pf = (BUF*)&h->priv_data;
	// I dont free(pf->buf);, I assume the data belongs to the app
	av_free(pf);
	return 0; 
}

static int mem_open(URLContext *h, const char *pseudofilename, int flags)
{
	// URL syntax: hpany:0x12345678
	int 		r = -ENOENT;
	
	BUF*		af;

    h->is_streamed = 1;
    av_log(NULL, AV_LOG_ERROR, "mem_open\n");
	pseudofilename += strlen(mem_protocol.name) + 1;
	af = (BUF *)av_malloc(sizeof(BUF));
	af->buf = (char*) strtoul(pseudofilename, NULL, 16);
	af->buflen = 32768;
	af->bufused = 0;

    af->FRead = fopen("G:\\a_pas_ok.ts", "rb");

    h->max_packet_size = 32768;
	h->priv_data = af;
	return 0;
}

static int mem_read(URLContext *h, unsigned char *buf, int size)
{
    BUF*	af = h->priv_data;
    int n, res;

    av_log(NULL, AV_LOG_ERROR, "mem_read\n");
    n = size;
    /*n = FFMIN(size, af->buflen - af->bufused);
    if (n < 0)
    {
        return -1;
    }*/
    av_log(NULL, AV_LOG_ERROR, "Ask to read %d bytes. ", n);
    res = fread(buf, 1, n, af->FRead);
    af->bufused += res;
    av_log(NULL, AV_LOG_ERROR, "%d bytes have been read. Buf used = %d\n", res, af->bufused);
    return res;
}

static int mem_write(URLContext *h, unsigned char *buf, int size)
{
    av_log(NULL, AV_LOG_ERROR, "mem_write\n");
	/*BUF*	af = h->priv_data;
	int		n;
	n = min(size, af->buflen-af->bufused);
	if(n<0)
		return -1;
	memcpy(af->buf+af->bufused, buf, n);
	af->buf_used+=size;
	return n;*/
	return 0;
}

static offset_t mem_seek(URLContext *h, offset_t pos, int whence)
{
    av_log(NULL, AV_LOG_ERROR, "mem_seek pos : %d whence %d\n", pos, whence);
    return 0;
}

URLProtocol mem_protocol = {
	"mem",
	mem_open,
	mem_read,
	mem_write,
	/*mem_seek,*/NULL,
	mem_close
};
